<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

add_shortcode( 'vcx_schedule', 'vcx_schedule_function');


/**
 * Short Code
 * @param $atts
 * @return string
 */

function vcx_schedule_function($atts) {

    extract(shortcode_atts(array(
        'menu_position' => 'tab-left',
        'menu_style'    => 'default',
        'show_more_btn'    => 'yes',
        'gap_type'      => 'gap',
        'order_by'		=> 'date',
        'order'			=> 'DESC',
    ), $atts));


    ob_start(); ?>

    <section>
        <div id="lgx-schedule" class="lgx-schedule">
            <div class="lgx-schedule-inner">
                <div class="lgx-tab lgx-<?php echo esc_attr($menu_position);?>">


                    <?php
                    $taxonomy = 'schedule_cat';
                    $terms = get_terms($taxonomy); // Get all terms of a taxonomy
                    $i = 1;
                    if ( $terms && !is_wp_error( $terms ) ) :

                        ?>
                        <ul class="nav nav-pills lgx-nav lgx-nav-<?php echo esc_attr($gap_type); ?>  lgx-nav-<?php echo esc_attr($menu_style) ?>">
                            <?php foreach ( $terms as $term ):   ?>
                                <li <?php echo ($i == 1) ?  'class="active"' : '' ;?> >
                                    <a data-toggle="pill" href="#schedule<?php echo $term->term_id; ?>">
                                        <h3><?php echo vcx_spilt_heading($term->name); ?></h3>
                                        <p><?php echo vcx_spilt_heading($term->description, 'left'); ?></p>
                                    </a>
                                </li>
                                <?php  $i++; endforeach; ?>
                        </ul>
                    <?php endif;?>

                    <div class="tab-content lgx-tab-content">
                        <?php
                        $count = 1;
                        if ( $terms && !is_wp_error( $terms ) ) :
                            foreach ( $terms as $term ):   ?>
                                <div id="schedule<?php echo $term->term_id; ?>" class="tab-pane fade in  <?php echo ($count == 1) ?  'active' : '' ;?>">
                                    <div class="panel-group" id="accordion<?php echo $term->term_id; ?>" role="tablist" aria-multiselectable="true">
                                        <?php

                                        $posts_array = get_posts(
                                            array(
                                                'posts_per_page' => -1,
                                                'post_type' => 'schedule',
                                                //'order'   => 'ASC',
                                                'order'				=> $order,
                                                'orderby'			=> $order_by,
                                                'tax_query' => array(
                                                    array(
                                                        'taxonomy' => 'schedule_cat',
                                                        'field' => 'term_id',
                                                        'terms' => $term->term_id,
                                                    )
                                                )
                                            )
                                        );

                                        $loop = 1;

                                        foreach ( $posts_array as $schedule) :
                                            $spekears_img = '';
                                            $spekears_name = '';
                                            $spekears_url = '';
                                            $spekears_designation = '';
                                            $id = $schedule->ID;
                                            $speakers_time          = get_post_meta($id,'__vcx__schedule-time',true);

                                            $spekears_id            = get_post_meta($id,'__vcx__schedule-speaker',true);


                                            $spekears_two_en            = get_post_meta($id,'__vcx__schedule-speaker_two_show',true);
                                            $spekears_id_two            = get_post_meta($id,'__vcx__schedule-speaker_two',true);


                                            $spekears_three_en            = get_post_meta($id,'__vcx__schedule-speaker_three_show',true);
                                            $spekears_id_three            = get_post_meta($id,'__vcx__schedule-speaker_three',true);


                                            $spekears_four_en            = get_post_meta($id,'__vcx__schedule-speaker_four_show',true);
                                            $spekears_id_four            = get_post_meta($id,'__vcx__schedule-speaker_four',true);

                                            $spekears_five_en            = get_post_meta($id,'__vcx__schedule-speaker_five_show',true);
                                            $spekears_id_five            = get_post_meta($id,'__vcx__schedule-speaker_five',true);



                                            $schedule_locations      = get_post_meta($id,'__vcx__schedule-location',true);

                                            // Replace Price
                                            $search_a = array('[',']');
                                            $replace_b = array('<span> ',' </span>');
                                            $speakers_time =  !empty($speakers_time) ? str_replace($search_a, $replace_b, $speakers_time) : '';

                                            if(!empty($spekears_id)) {
                                                $spekears_img           = wp_get_attachment_image_src(get_post_thumbnail_id( $spekears_id ), array(150,150), true);
                                                $spekears_img           = $spekears_img[0];
                                                $spekears_name          =  get_the_title($spekears_id);
                                                $spekears_url           = get_permalink($spekears_id);
                                                $spekears_designation   = get_post_meta($spekears_id,'__vcx__speaker-designation','eplano-thumbnails',true);
                                            }


                                            if(!empty($spekears_id_two)) {
                                                $spekears_img_two           = wp_get_attachment_image_src(get_post_thumbnail_id( $spekears_id_two ), array(150,150),true);
                                                $spekears_img_two           = $spekears_img_two[0];
                                                $spekears_name_two          =  get_the_title($spekears_id_two);
                                                $spekears_url_two           = get_permalink($spekears_id_two);
                                                $spekears_designation_two   = get_post_meta($spekears_id_two,'__vcx__speaker-designation',true);
                                            }


                                            if(!empty($spekears_id_three)) {
                                                $spekears_img_three           = wp_get_attachment_image_src(get_post_thumbnail_id( $spekears_id_three ), array(150,150),true);
                                                $spekears_img_three           = $spekears_img_three[0];
                                                $spekears_name_three          =  get_the_title($spekears_id_three);
                                                $spekears_url_three           = get_permalink($spekears_id_three);
                                                $spekears_designation_three  = get_post_meta($spekears_id_three,'__vcx__speaker-designation',true);
                                            }


                                            if(!empty($spekears_id_four)) {
                                                $spekears_img_four           = wp_get_attachment_image_src(get_post_thumbnail_id( $spekears_id_four ), array(150,150),true);
                                                $spekears_img_four           = $spekears_img_four[0];
                                                $spekears_name_four          =  get_the_title($spekears_id_four);
                                                $spekears_url_four          = get_permalink($spekears_id_four);
                                                $spekears_designation_four  = get_post_meta($spekears_id_four,'__vcx__speaker-designation',true);
                                            }



                                            if(!empty($spekears_id_four)) {
                                                $spekears_img_four           = wp_get_attachment_image_src(get_post_thumbnail_id( $spekears_id_four ), array(150,150),true);
                                                $spekears_img_four           = $spekears_img_four[0];
                                                $spekears_name_four          =  get_the_title($spekears_id_four);
                                                $spekears_url_four          = get_permalink($spekears_id_four);
                                                $spekears_designation_four  = get_post_meta($spekears_id_four,'__vcx__speaker-designation',true);
                                            }



                                            if(!empty($spekears_id_five)) {
                                                $spekears_img_five           = wp_get_attachment_image_src(get_post_thumbnail_id( $spekears_id_five ), array(150,150),true);
                                                $spekears_img_five           = $spekears_img_five[0];
                                                $spekears_name_five          =  get_the_title($spekears_id_five);
                                                $spekears_url_five           = get_permalink($spekears_id_five);
                                                $spekears_designation_five   = get_post_meta($spekears_id_five,'__vcx__speaker-designation',true);
                                            }



                                            $loop_id = $id .$loop . $term->term_id;

                                            ?>

                                            <div class="panel panel-default lgx-panel">
                                                <div class="panel-heading" role="tab" id="headingOne<?php echo $loop_id; ?>">
                                                    <div class="panel-title">
                                                        <a <?php echo ($loop != 1) ?  'class="collapsed"' : '' ;?> role="button" data-toggle="collapse" data-parent="#accordion<?php echo $term->term_id; ?>" href="#collapseOne<?php echo $loop_id; ?>" aria-expanded="true" aria-controls="collapseOne<?php echo $loop_id; ?>">
                                                            <div class="lgx-single-schedule">
                                                                <div class="author <?php echo ($spekears_two_en == 'yes') ? 'author-multi' : ''; ?>">
                                                                    <img src="<?php echo esc_url( $spekears_img); ?>" alt="<?php echo $spekears_name; ?>"/>

                                                                    <?php if($spekears_two_en == 'yes'): ?>
                                                                        <img src="<?php echo esc_url( $spekears_img_two); ?>" alt="<?php echo $spekears_name_two; ?>"/>
                                                                    <?php endif; ?>

                                                                    <?php if($spekears_three_en == 'yes'): ?>
                                                                        <img src="<?php echo esc_url( $spekears_img_three); ?>" alt="<?php echo $spekears_name_three; ?>"/>
                                                                    <?php endif; ?>


                                                                    <?php if($spekears_four_en == 'yes'): ?>
                                                                        <img src="<?php echo esc_url( $spekears_img_four); ?>" alt="<?php echo $spekears_name_four; ?>"/>
                                                                    <?php endif; ?>

                                                                    <?php if($spekears_five_en == 'yes'): ?>
                                                                        <img src="<?php echo esc_url( $spekears_img_five); ?>" alt="<?php echo $spekears_name_five; ?>"/>
                                                                    <?php endif; ?>




                                                                </div>
                                                                <div class="schedule-info">
                                                                    <h4 class="time"><?php echo ( ($speakers_time) ? $speakers_time : ' '); ?></h4>
                                                                    <h3 class="title"><?php echo $schedule->post_title; ?></h3>
                                                                    <h4 class="author-info">
                                                                        <?php esc_html_e('By', 'vcx-theme-core') ?>
                                                                        <span>
                                                                                    <?php echo($spekears_name ? $spekears_name : ' '); ?>
                                                                                </span>
                                                                        , <?php echo ($spekears_designation ? $spekears_designation : ' '); ?>
                                                                        <?php if($spekears_two_en == 'yes'): ?>
                                                                            <b>|</b> <span><?php echo($spekears_name_two ? $spekears_name_two : ' '); ?> </span> ,
                                                                            <?php echo($spekears_designation_two ? $spekears_designation_two : ' '); ?>
                                                                        <?php endif; ?>
                                                                    </h4>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                </div>
                                                <div id="collapseOne<?php echo $loop_id; ?>" class="panel-collapse collapse <?php echo ($loop == 1) ?  'in' : '' ;?>" role="tabpanel" aria-labelledby="headingOne<?php echo $loop_id; ?>">
                                                    <div class="panel-body">
                                                        <p class="text"><?php echo $schedule->post_excerpt; ?>
                                                            <?php echo ($show_more_btn == 'yes') ? ' <a class="lgx-btn-simple" href="'.get_permalink($id).'" target="_blank">'.esc_html__('View Details', 'vcx-theme-core').'</a>' : '' ;?>

                                                        </p>
                                                        <?php echo !empty($schedule_locations) ? ('<h4 class="location"> <strong>'.esc_html__('Location:', 'vcx-theme-core').'</strong> </h4>   '. vcx_span_heading($schedule_locations)) : ''; ?>


                                                    </div>
                                                </div>
                                            </div>  <!--// item -->


                                        <?php $loop++; endforeach;

                                        wp_reset_postdata();?>

                                    </div> <!--//accordian -->
                                </div> <!--//Tabs -->
                                <?php  $count++;  endforeach; ?>
                        <?php endif;?>

                    </div> <!-- //.tab-content -->

                </div><!--CSI TAB-->
            </div><!-- //.INNER -->
        </div>
    </section>



    <?php
    return ob_get_clean();

}


/**
 * Visual Composer
 *
 * Visual Composer for Schedule
 */

if (class_exists('WPBakeryVisualComposerAbstract')) {
    vc_map(array(
        "name" => esc_html__("Schedule Section", 'hcx-event-pro'),
        "base" => "vcx_schedule",
        "class" => "",
        "description" => esc_html__("Display all Schedule", 'hcx-event-pro'),
        "category" => esc_html__('Emeet', 'hcx-event-pro'),

        "params" => array(

            array(
                "type" 			=> "dropdown",
                "heading" 		=> esc_html__("Menu Position", 'vcx-theme-core'),
                "param_name" 	=> "menu_position",
                "value" 		=> array('Left'=>'tab-left','Top'=>'tab2', 'Vertical' => 'tab-vertical'),
            ),

            array(
                "type" 			=> "dropdown",
                "heading" 		=> esc_html__("Menu Style", 'vcx-theme-core'),
                "param_name" 	=> "menu_style",
                "value" 		=> array('Default'=>'default','Colorful'=>'colorful','Background'=>'background'),
            ),


            array(
                "type" 			=> "dropdown",
                "heading" 		=> esc_html__("Menu Gap Type", 'vcx-theme-core'),
                "param_name" 	=> "gap_type",
                "value" 		=> array('Gap'=>'gap','No Gap'=>'nogap'),
            ),

            array(
                "type" 			=> "dropdown",
                "heading" 		=> esc_html__("Show View More Button", 'vcx-theme-core'),
                "param_name" 	=> "show_more_btn",
                "value" 		=> array('Yes'=>'yes','No'=>'no'),
            ),



            array(
                "type" 			=> "dropdown",
                "heading" 		=> esc_html__("Gap Type", 'vcx-theme-core'),
                "param_name" 	=> "gap_type",
                "value" 		=> array('Default'=>'default','Colorful'=>'colorful'),
            ),


            array(
                "type" 			=> "dropdown",
                "heading" 		=> esc_html__("Order", 'hcx-event-pro'),
                "param_name" 	=> "order",
                "value" 		=> array('Select'=>'','DESC'=>'DESC','ASC'=>'ASC'),
            ),
            array(
                "type" 			=> "dropdown",
                "heading" 		=> esc_html__("OderBy", 'hcx-event-pro'),
                "param_name" 	=> "order_by",
                "value" 		=> array('Select'=>'','Date'=>'date','Title'=>'title','Modified'=>'modified','Author'=>'author','Random'=>'rand'),
            ),

        )
    ));
}