<?php

/**
 * Initiate plugin installation actions
 *
 * @package    ERForms
 * @author     ERForms
 * @since      1.0.0
 */
class ERForms_Install {

    /**
     *
     * @since 1.0.0
     */
    public function __construct() {
        // When activated, trigger install method
        register_activation_hook(ERFORMS_PLUGIN_FILE, array($this, 'install'));

        // Watch for new multisite blogs
        add_action('wpmu_new_blog', array($this, 'new_multisite_blog'), 10, 6);
    }

    /**
     *
     * @since 1.0.0
     * @param boolean $network_wide
     */
    public function install($network_wide = false) {
        // Check if we are on multisite and network activating
        if (is_multisite() && $network_wide) {

            // Multisite - go through each subsite and run the installer
            if (function_exists('get_sites') && class_exists('WP_Site_Query')) {
                // WP 4.6+
                $sites = get_sites();
                foreach ($sites as $site) {
                    switch_to_blog($site->blog_id);
                    $this->run_install();
                    restore_current_blog();
                }
            } else {
                $sites = wp_get_sites(array('limit' => 0));
                foreach ($sites as $site) {
                    switch_to_blog($site['blog_id']);
                    $this->run_install();
                    restore_current_blog();
                }
            }
        } else {
            // Normal single site
            $this->run_install();
        }


        // Abort so we only set the transient for single site installs
        if (is_network_admin() || isset($_GET['activate-multi'])) {
            return;
        }

        // Add transiet to trigger redirect to the Welcome screen
        set_transient('erforms_activation_redirect', true, 30);
    }

    /**
     * Run the actual installer.
     *
     * @since 1.3.0
     */
    function run_install() {
        // Hook for addons
        do_action('erforms_install');

        // Set current version, to be referenced in future updates
        //update_option('erforms_version', ERFORMS_VERSION);

        // Store the date when the initial activation was performed
        $activated = get_option('erforms_activated', array());
        if (empty($activated)) {
            $activated = time();
            update_option('erforms_activated', $activated);
        }
    }

    /**
     * When a new site is created in multisite, see if we are network activated,
     * and if so run the installer.
     *
     * @since 1.3.0
     * @param int $blog_id
     * @param int $user_id
     * @param string $domain
     * @param string $path
     * @param int $site_id
     * @param array $meta
     */
    function new_multisite_blog($blog_id, $user_id, $domain, $path, $site_id, $meta) {

        if (is_plugin_active_for_network(plugin_basename(ERFORMS_PLUGIN_FILE))) {
            switch_to_blog($blog_id);
            $this->run_install();
            restore_current_blog();
        }
    }

}

new ERForms_Install;